<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type Device
 * The device object specifies a single physical or virtual device together with all its properties. */
final class DeviceType implements AutoGenerationInterface
{
    /**
     * The device account assignments
     * @var null|iterable
     */
    public ?iterable $accountAssignments = null;
    /**
     * Gets all array attributes for this device (simple attached attributes or custom attributes)
     * @var null|iterable
     */
    public ?iterable $arrayAttributes = null;
    /**
     * A device's asset tag
     */
    public ?string $assetTag = null;
    /**
     * Gets all attributes for this device (simple attached attributes or custom attributes)
     * @var null|iterable
     */
    public ?iterable $attachedAttributes = null;
    /**
     * A device's BIOS
     */
    public ?BiosType $bios = null;
    /**
     * The clusters which this device belongs to
     * @var null|iterable
     */
    public ?iterable $clusters = null;
    /**
     * The associated computer account assigment from Microsoft's Active Directory.
     * @var null|iterable
     */
    public ?iterable $computerAccountAssignment = null;
    /**
     * A device's NetBIOS computer name
     */
    public ?string $computername = null;
    /**
     * The time when the device was scanned for the first time.
     */
    public $creationTime = null;
    /**
     * The duration in milliseconds that were required to write this device's data to the database
     */
    public $databaseDuration = null;
    /**
     * Gets all device comparison summaries for this device. When there are multiple registered device s, then you get a response with changes for each of them.
     * @var null|iterable
     */
    public ?iterable $deviceComparisonSummaries = null;
    /**
     * Gets the list of all devices which are assigned to this group.
     * @var null|iterable
     */
    public ?iterable $deviceGroups = null;
    /**
     * The list of all diagnostic events.

Diagnostic events help users to identify discovery issues that result from missing configurations, protocols or issues
with the device.
     * @var null|iterable
     */
    public ?iterable $diagnosticEvents = null;
    /**
     * The directory item that this device belongs to.
     */
    public ?DirectoryType $directory = null;
    /**
     * The list of disabled protocols for this device
     * @var null|iterable|DiscoveryProtocolEnum[]
     */
    public ?iterable $disabledProtocols = null;
    /**
     * The list of discovery jobs that has seen this device.
     * @var null|iterable
     */
    public ?iterable $discoveredByJobs = null;
    /**
     * The duration in milliseconds that were required to discover this device
     */
    public $discoveryDuration = null;
    /**
     * The last discovery timestamp. This is the timestamp of the current data.
     */
    public $discoveryTime = null;
    /**
     * The list of disk partitions.
     * @var null|iterable
     */
    public ?iterable $diskPartitions = null;
    /**
     * The list of physical disk slots.
     * @var null|iterable
     */
    public ?iterable $diskSlots = null;
    /**
     * The list of all events like shutdown, reboot, and others.
     * @var null|iterable
     */
    public ?iterable $events = null;
    /**
     * Gets all hashes for this device
     * @var null|iterable
     */
    public ?iterable $hashes = null;
    /**
     * A device's hardware version
     */
    public ?string $hwVersion = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The list of iSCSI initiator ports.
     * @var null|iterable
     */
    public ?iterable $iscsiInitiators = null;
    /**
     * The list of iSCSI ports.
     * @var null|iterable
     */
    public ?iterable $iscsiPorts = null;
    /**
     * The list of iSCSI target ports.
     * @var null|iterable
     */
    public ?iterable $iscsiTargets = null;
    /**
     * Gets the list of issued client access licenses for this device
     * @var null|iterable
     */
    public ?iterable $issuedClientAccessLicenses = null;
    /**
     * The Java Risk summary for this device.
     */
    public ?JavaRiskSummaryType $javaRiskSummary = null;
    /**
     * Gets the list of all Java license risks
     * @var null|iterable
     */
    public ?iterable $javaRisks = null;
    /**
     * The last seen timestamp. This timestamp defines when the device has been seen the last time directly or indirectly (e.g. via a VMware VCenter installation).
     */
    public $lastSeenTime = null;
    /**
     * The time when the support entitlements have been read for the last time
     */
    public $lastSupportEntitlementTime = null;
    /**
     * The list of TCP/IP ports that are in listen mode.
     * @var null|iterable
     */
    public ?iterable $listeningPorts = null;
    /**
     * The list of logical disks.
     * @var null|iterable
     */
    public ?iterable $logicalDisks = null;
    /**
     * A logical serial number is used by some vendors in order to inject a logical serial number into the BIOS and overwrite
the device's physical serial number. This approach is used by some devices to work around licenses that are tied to
the device's serial number.
     */
    public ?string $logicalSerialNumber = null;
    /**
     * The virtual datacenters that are managed by this device (e.g. by a VCenter installation running on this device).
     * @var null|iterable
     */
    public ?iterable $managedVirtualDatacenters = null;
    /**
     * The device's manufacturer
     */
    public ?string $manufacturer = null;
    /**
     * The manufacturing timestamp
     */
    public $manufacturingTime = null;
    /**
     * The list of memory module slots with their memory modules (if populated).
     * @var null|iterable
     */
    public ?iterable $memoryModuleSlots = null;
    /**
     * The list of mobile broadband devices (modems).
     * @var null|iterable
     */
    public ?iterable $mobileBroadbandDevices = null;
    /**
     * The device's model
     */
    public ?string $model = null;
    /**
     * The list of module slots with their modules (if populated).
     * @var null|iterable
     */
    public ?iterable $moduleSlots = null;
    /**
     * The device's name
     */
    public ?string $name = null;
    /**
     * The list of network interfaces.
     * @var null|iterable
     */
    public ?iterable $networkInterfaces = null;
    /**
     * The network neighborhood/domain that this device belongs to.
     */
    public ?NetworkNeighborhoodType $networkNeighborhood = null;
    /**
     * A device's operating system
     */
    public ?OperatingSystemType $operatingSystem = null;
    /**
     * A device's part number
     */
    public ?string $partNumber = null;
    /**
     * Get the physical host for a virtual machine
     */
    public ?DeviceType $physicalHost = null;
    /**
     * The list of processor slots with their processors (if populated).
     * @var null|iterable
     */
    public ?iterable $processorSlots = null;
    /**
     * The SNMP read community configured for this device
     */
    public ?SnmpCommunityType $readCommunity = null;
    /**
     * The set of roles for a device.
     * @var null|iterable|DeviceRoleEnum[]
     */
    public ?iterable $roles = null;
    /**
     * Gets all scalar attributes for this device (simple attached attributes or custom attributes)
     * @var null|iterable
     */
    public ?iterable $scalarAttributes = null;
    /**
     * The list of all scheduled tasks defined for this computer.
     * @var null|iterable
     */
    public ?iterable $scheduledTasks = null;
    /**
     * The list of discovery jobs that has seen this device.
     * @var null|iterable
     */
    public ?iterable $seenByJobs = null;
    /**
     * A device's serial number
     */
    public ?string $serialNumber = null;
    /**
     * The basic SNMP agent information for this device.
     */
    public ?SnmpAgentDataType $snmpAgentData = null;
    /**
     * The SNMPv3 account configured for this device
     */
    public ?SnmpV3AccountType $snmpV3Account = null;
    /**
     * The list of TCP/IP connections where the current device is initiating a TCP/IP connection.
     * @var null|iterable
     */
    public ?iterable $sourceTcpIpPortConnections = null;
    /**
     * Gets all support entitlements for this device
     * @var null|iterable
     */
    public ?iterable $supportEntitlements = null;
    /**
     * The system board for this device.
     */
    public ?SystemBoardType $systemBoard = null;
    /**
     * The list of TCP/IP connections where the current device is the target of a TCP/IP connection.
     * @var null|iterable
     */
    public ?iterable $targetTcpIpPortConnections = null;
    /**
     * The total RAM for this device in MB
     */
    public $totalRAM = null;
    /**
     * The TPM module for this device.
     */
    public ?TpmModuleType $tpmModule = null;
    /**
     * A device's type
     */
    public ?DeviceTypeEnum $type = null;
    /**
     * A device's unqiue id (if it exists)
     */
    public ?string $uniqueId = null;
    /**
     * The list of video controller slots.
     * @var null|iterable
     */
    public ?iterable $videoControllerSlots = null;
    /**
     * The virtual datacenters that a device belongs to.
     * @var null|iterable
     */
    public ?iterable $virtualDatacenters = null;
    /**
     * Finds the array custom attribute values for a specific path
     */
    public ?DeviceArrayAttributeType $arrayCustomAttributeByPath = null;
    /**
     * Returns the list of attached devices.
Attached devices are usually monitors attached to a PC/laptop, local printers attached to a device etc..
     * @var null|iterable
     */
    public ?iterable $attachedDevices = null;
    /**
     * Finds a folder for a specific path
     */
    public ?DeviceAttributeType $customAttributeFolderByPath = null;
    /**
     * Gets the comparison summaries for a specific device and integration.
     */
    public ?DeviceComparisonSummaryType $deviceComparisonSummary = null;
    /**
     * The discovery log as XML string.
     */
    public ?string $discoveryLog = null;
    /**
     * Returns the discovery as parsed object with a hierarchy. This method is used by the UI to display a discovery log in a tree structure
     */
    public $discoveryLogObject = null;
    /**
     * A device's discovery protocol status
     */
    public ?DeviceDiscoveryProtocolStatusType $discoveryProtocolStatus = null;
    /**
     * Returns the list of hosted virtual machines on this device.
     * @var null|iterable
     */
    public ?iterable $hostedVirtualMachines = null;
    /**
     * Gets the main IP4 transport (if there is any)
     */
    public ?IP4TransportType $mainIP4Transport = null;
    /**
     * Gets the main IP6 transport (if there is any)
     */
    public ?IP6TransportType $mainIP6Transport = null;
    /**
     * The main IP4/IP6 address for the device (if the IP4/IP6 address exists). !!!! IP6 would be treated as main if both exists.
     */
    public ?string $mainIPAddress = null;
    /**
     * Returns the list of managed virtualization servers.
For instance the list of managed ESX servers managed by a VCenter server.
     * @var null|iterable
     */
    public ?iterable $managedVirtualizationServers = null;
    /**
     * Finds the scalar custom attribute values for a specific path
     */
    public ?DeviceAttributeType $scalarCustomAttributeByPath = null;
    /**
     * Finds the scalar custom attributes within a specific folder
     * @var null|iterable
     */
    public ?iterable $scalaryPath = null;
    /**
     * The list of related devices where this device is the relation's source.
     * @var null|iterable
     */
    public ?iterable $sourceRelatedDevices = null;
    /**
     * The list of related devices where this device is the relation's source with a specific connector type.
     * @var null|iterable
     */
    public ?iterable $sourceRelatedDevicesByConnectorType = null;
    /**
     * The list of related devices where this device is the relation's source with one of the specified connector types.
     * @var null|iterable
     */
    public ?iterable $sourceRelatedDevicesByConnectorTypes = null;
    /**
     * Returns the list of stack members for a stacked switch.
A stacked switch is a virtual switch being created when stacking multiple physical switches together.
     * @var null|iterable
     */
    public ?iterable $stackedSwitchMembers = null;
    /**
     * The list of related devices where this device is the relation's target.
     * @var null|iterable
     */
    public ?iterable $targetRelatedDevices = null;
    /**
     * The list of related devices where this device is the relation's target with a specific connector type.
     * @var null|iterable
     */
    public ?iterable $targetRelatedDevicesByConnectorType = null;
    /**
     * The list of related devices where this device is the relation's target with one of the specified connector types.
     * @var null|iterable
     */
    public ?iterable $targetRelatedDevicesByConnectorTypes = null;
    /**
     * The list of TCP/IP ports and TCP/IP connections where the current device is either the source of the destination of a TCP/IP connection.
     * @var null|iterable
     */
    public ?iterable $tcpIpConnections = null;
    /**
     * A flag whether a device is virtual or not
     */
    public ?bool $isVirtual = null;
}