<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DiagramEntityRelationInput
 * A diagram entity relation * @property null|bool $acceptsDepth = null A flag to show if the relation accepts max depth application or not
 * @property null|DiagramTemplateIdEnum $askedByTemplateId = null The template id for which the relation is asked, used for input purposes
 * @property null|ContextMenuItemInputInputType $contextMenuItem = null The diagram context menu item
 * @property null|iterable $excludeParentEntityIds = null The entity id's to exclude from applying this relation.
 * @property null|DiagramRelationIdEnum $id = null The relation id
 * @property null|int $maxDepth = null The relation max hops
 * @property null|iterable|DiagramEntityRelationInputInputType[] $relations = null The child relations
 * @property null|iterable|AddOnProductEnum[] $requiredAddOns = null The required addOns for the relation
 * @property mixed $targetParentEntityId = null The entity id for which this relation will apply. If empty, it applies to all entities except the ones defined in excludeParentEntityId
 * @property null|JDiagramRelationTypeEnum $type = null The relation type
 */
final class DiagramEntityRelationInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'askedByTemplateId') {
            return new DiagramTemplateIdEnum($value);
        }

        if ($name === 'contextMenuItem') {
            return new ContextMenuItemInputInputType($value);
        }

        if ($name === 'id') {
            return new DiagramRelationIdEnum($value);
        }

        if ($name === 'relations') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DiagramEntityRelationInputInputType($v)); })($value);
        }

        if ($name === 'requiredAddOns') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new AddOnProductEnum($v)); })($value);
        }

        if ($name === 'type') {
            return new JDiagramRelationTypeEnum($value);
        }

        return $value;
    }
}