<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DiscoveryJob
 * A discovery job object. A discovery job is a definition of networks, domains, AD entries to be scanned. There can be multiple jobs scanning different areas or the network. */
final class DiscoveryJobType implements AutoGenerationInterface
{
    /**
     * Sync directories trees.
     */
    public ?bool $agingOutCompleted = null;
    /**
     * The description for the job.
     */
    public ?string $description = null;
    /**
     * The list of device queue entries for this discovery job.
     * @var null|iterable
     */
    public ?iterable $deviceQueueEntries = null;
    /**
     * Sync computer accounts.
     */
    public ?bool $directorySyncComputerAccounts = null;
    /**
     * Sync directories trees.
     */
    public ?bool $directorySyncDirectoryTree = null;
    /**
     * Sync directories even on networks.
     */
    public ?bool $directorySyncNetworks = null;
    /**
     * Sync user groups.
     */
    public ?bool $directorySyncUserGroups = null;
    /**
     * Sync users.
     */
    public ?bool $directorySyncUsers = null;
    /**
     * The discovery cloud sync log as XML string.
     */
    public ?string $discoveryCloudSyncLog = null;
    /**
     * The discovery config log as XML string.
     */
    public ?string $discoveryConfigLog = null;
    /**
     * The discovery directory log as XML string.
     */
    public ?string $discoveryDirectoryLog = null;
    /**
     * The discovery directory sync log as XML string.
     */
    public ?string $discoveryDirectorySyncLog = null;
    /**
     * The discovery network neighborhood log as XML string.
     */
    public ?string $discoveryNetworkNeighborhoodLog = null;
    /**
     * The discovery network sync log as XML string.
     */
    public ?string $discoveryNetworkSyncLog = null;
    /**
     * The discovery ping log as XML string.
     */
    public ?string $discoveryPingLog = null;
    /**
     * Minimum time between two discovery jobs.
     */
    public ?int $doNotDiscoverTwiceWithinNSeconds = null;
    /**
     * The execution schedule of this job
     */
    public ?ScheduleType $executionSchedule = null;
    /**
     * The internal id for this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The last timestamp the job was finished.
     */
    public $lastFinishedAt = null;
    /**
     * The last timestamp the job was started.
     */
    public $lastStartAt = null;
    /**
     * The discovery config log modification time.
     */
    public $logModificationTime = null;
    /**
     * Maximum number of devices parallel discovered.
     */
    public ?int $maxConcurrentDevices = null;
    /**
     * The name for the job.
     */
    public ?string $name = null;
    /**
     * The status of the job.
     */
    public ?TaskStatusEnum $status = null;
    /**
     * Sync cloud services.
     */
    public ?bool $syncCloudServices = null;
    /**
     * Returns the discovery cloud sync log as parsed object with a hierarchy. This method is used by the UI to display a discovery cloud sync log in a tree structure
     */
    public $discoveryCloudSyncLogObject = null;
    /**
     * Returns the discovery config log as parsed object with a hierarchy. This method is used by the UI to display a discovery config log in a tree structure
     */
    public $discoveryConfigLogObject = null;
    /**
     * Returns the discovery directory log as parsed object with a hierarchy. This method is used by the UI to display a discovery directory log in a tree structure
     */
    public $discoveryDirectoryLogObject = null;
    /**
     * Returns the discovery directory sync log as parsed object with a hierarchy. This method is used by the UI to display a discovery directory sync log in a tree structure
     */
    public $discoveryDirectorySyncLogObject = null;
    /**
     * Returns the discovery network neighborhood log as parsed object with a hierarchy. This method is used by the UI to display a discovery network neighborhood log in a tree structure
     */
    public $discoveryNetworkNeighborhoodLogObject = null;
    /**
     * Returns the discovery network sync log as parsed object with a hierarchy. This method is used by the UI to display a discovery network sync log in a tree structure
     */
    public $discoveryNetworkSyncLogObject = null;
    /**
     * Returns the discovery ping log as parsed object with a hierarchy. This method is used by the UI to display a discovery ping log in a tree structure
     */
    public $discoveryPingLogObject = null;
}