<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type PortConnection
 * The port connection object is used to store
- an open TCP/IP or UDP port
- a TCP/IP connection between two processes on the same or different device

The connectionState defines whether the port is listening or whether it is a TCP/IP connection. */
final class PortConnectionType implements AutoGenerationInterface
{
    /**
     * The time when this connection/open port has been scanned for the last time.
     */
    public $discoveryTime = null;
    /**
     * The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
     */
    public ?string $id = null;
    /**
     * The cipher used for the SSL connection
     */
    public ?string $sslCipher = null;
    /**
     * The protocol for the SSL connection (e.g. TLS 1.2, TLS 1.3)
     */
    public ?string $sslProtocol = null;
    /**
     * The connection state.
     */
    public ?TcpConnectionStateEnum $state = null;
    /**
     * The connection state.
     */
    public ?PortConnectionTypeEnum $type = null;
    /**
     * The IP address that is used by the initiating process to establish this connection.
     */
    public ?string $sourceAddress = null;
    /**
     * The device that hosts the source of the TCP/IP connection.
     */
    public ?DeviceType $sourceDevice = null;
    /**
     * The description for a connection's source port.
     */
    public ?string $sourcePortDescription = null;
    /**
     * The name for a connection's source port.
     */
    public ?string $sourcePortName = null;
    /**
     * The source port that is used by the initiating process to establish this connection or listen on this port.
     */
    public ?int $sourcePortNumber = null;
    /**
     * The process that initiated the TCP/IP connection.
     */
    public ?ProcessType $sourceProcess = null;
    /**
     * The target IP address that this connection connects to.
     */
    public ?string $targetAddress = null;
    /**
     * The process that hosts the target of the TCP/IP connection.
     */
    public ?DeviceType $targetDevice = null;
    /**
     * The description for a connection's target port.
     */
    public ?string $targetPortDescription = null;
    /**
     * The name for a connection's target port.
     */
    public ?string $targetPortName = null;
    /**
     * The target port for this TCP/IP connection.
     */
    public ?int $targetPortNumber = null;
    /**
     * The process that is the target of the TCP/IP connection.
     */
    public ?ProcessType $targetProcess = null;
}