<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type UserInput
 * A user * @property null|AccountInputInputType $account = null The user account
 * @property null|string $canonicalName = null The user canonical name
 * @property null|CloudTypeEnum $cloudType = null A user's cloud type when the user is a cloud user
 * @property null|string $distinguishedName = null The user distinguish name
 * @property null|string $givenName = null The user given name
 * @property mixed $lastLogonTime = null The last logon time for this user
 * @property null|string $name = null The user name (this is not the login)
 * @property null|string $principalName = null The user principal (usually in the form <user>@<dnsdomain>
 * @property null|DiscoveredUserStatusEnum $status = null The user status.
 * @property null|string $surname = null The user surname
 * @property null|string $uniqueId = null The user unique id
 */
final class UserInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'account') {
            return new AccountInputInputType($value);
        }

        if ($name === 'cloudType') {
            return new CloudTypeEnum($value);
        }

        if ($name === 'status') {
            return new DiscoveredUserStatusEnum($value);
        }

        return $value;
    }
}