<?php

namespace idoit\Module\SyneticsJdisc\Model;

use idoit\Component\Logger;
use idoit\Module\SyneticsJdisc\Model\Dto\LogDto;
use Monolog\Formatter\LineFormatter;
use Monolog\Handler\StreamHandler;
use Monolog\Level;

class ImportLogger extends Logger
{
    /**
     * @param string   $name
     * @param LogDto   $logDto
     * @param int|null $level
     *
     * @return Logger
     */
    public static function getLogger(string $name, LogDto $logDto, int|null $level = null): Logger
    {
        $logHandler = new StreamHandler($logDto->getFullFileName(), $level ?? Level::Warning->value);

        // Keep the defaults, but allow line breaks and ignore empty 'context' and 'extra'.
        $logHandler->setFormatter(new LineFormatter(null, 'Y-m-d H:i:s', true, true));

        $log = new self($name);
        $log->pushHandler($logHandler);

        return $log;
    }
}
