<style>
    [{include file=$cssPath}]
</style>
<div id="column-settings" class="column-settings">
    <div class="outer-content header">
        <h2>Column settings</h2>
        <button type="button" class="btn popup-closer" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]">
            <img src="[{$dirImages}]axialis/basic/symbol-cancel-outline.svg" alt="[{isys type="lang" ident="LC__POPUP__CLOSE"}]"/>
        </button>
    </div>
    <div class="content">
        <ul>
            <li>
                <input type="checkbox" name="jdisc-os" id="jdisc-os"/><label for="jdisc-os">[{isys type="lang" ident="LC__MODULE__JDISC__OBJECT_TYPE_ASSIGNMENTS__JDISC_OS"}]</label>
            </li>
            <li>
                <input type="checkbox" name="object-title-transform" id="object-title-transform"/><label for="object-title-transform">[{isys type="lang" ident="LC__MODULE__JDISC__OBJECT_TYPE_ASSIGNMENTS__TITLE_TRANSFORM"}]</label>
            </li>
            <li>
                <input type="checkbox" name="fqdn-addition" id="fqdn-addition"/><label for="fqdn-addition">[{isys type="lang" ident="LC__MODULE__JDISC__OBJECT_TYPE_ASSIGNMENTS__FQDN_ADDITION"}]</label>
            </li>
            <li>
                <input type="checkbox" name="port-filter" id="port-filter" /><label for="port-filter">[{isys type="lang" ident="LC__MODULE__JDISC__OBJECT_TYPE_ASSIGNMENTS__PORT_FILTER"}]</label>
            </li>
            <li>
                <input type="checkbox" name="location" id="location"/><label for="location">[{isys type="lang" ident="LC__MODULE__JDISC__OBJECT_TYPE_ASSIGNMENTS__LOCATION"}]</label>
            </li>
        </ul>
    </div>
    <div class="outer-content footer">
        <button type="button" class="btn save-button">
            <img src="[{$dirImages}]axialis/basic/symbol-ok.svg" alt="" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_SAVE"}]</span>
        </button>
        <button type="button" class="btn popup-closer ml5" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]">
            <img src="[{$dirImages}]axialis/basic/symbol-cancel.svg" alt="[{isys type="lang" ident="LC__POPUP__CLOSE"}]"/>
            <span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<script language="javascript" type="text/javascript">
    (function () {
        'use strict';

        var $popup = $('column-settings');
        var $columnSettingsContainer = $('C__MODULE__JDISC__COLUMN_SETTINGS');
        var $columnSettings = JSON.parse($columnSettingsContainer.value);

        $popup.on('click', '.popup-closer', function () {
            Modal.close($popup.up('.modal'));
        });

        $popup.on('click', '.save-button', function () {
            let newSettings = {
                'jdisc-os': 0,
                'object-title-transform': 0,
                'fqdn-addition': 0,
                'port-filter': 0,
                'location': 0
            };

            $$('#column-settings input[type="checkbox"]').each(function(item) {
                if (item.checked) {
                    newSettings[item.id] = 1
                }
            });
            $columnSettingsContainer.value = JSON.stringify(newSettings);
            window.applyColumnSettings(newSettings);
            Modal.close($popup.up('.modal'));
        });

        for (var type in $columnSettings) {
            if ($columnSettings[type] == 1) {
                $(type).checked = true;
            }
        }

    }());
</script>
