<?php

/**
 * i-doit
 *
 *
 * @package    i-doit
 * @subpackage Workflow
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_workflow_list extends isys_workflow
{
    /**
     * @var isys_workflow_list
     */
    private static $m_instance;

    /**
     * @var array
     */
    private $m_columns;

    /**
     * @var array
     */
    private $m_headers = [];

    /**
     * @var array
     */
    private $m_links;

    /**
     * @var array
     */
    private $m_tables;

    /**
     * Singleton instance.
     *
     * @return  isys_workflow_list
     */
    public static function get()
    {
        if (!isset(self::$m_instance)) {
            self::$m_instance = new self;
            self::$m_instance->init();
        }

        return self::$m_instance;
    }

    public function add_column($p_index, $p_key, $p_title, $p_value)
    {
        if (!array_key_exists($p_key, $this->m_columns)) {
            // First, add the new header.. if its really new and not known already.
            $this->add_header($p_title, $p_key);

            // Then, add the column with its content.
            $this->m_columns[$p_index][$p_key] = $p_value;

            // Finally, return the index.
            return $p_index;
        }
    }

    public function add_header($p_title, $p_key)
    {
        if (is_array($this->m_headers)) {
            if (!array_key_exists($p_key, $this->m_headers)) {
                $this->m_headers[$p_key] = [
                    "title"  => $p_title,
                    "active" => true
                ];
            }
        }
    }

    public function remove_header($p_key)
    {
        if (array_key_exists($p_key, $this->m_headers)) {
            unset($this->m_headers[$p_key]);
        }
    }

    public function remove_column($p_index)
    {
        unset($this->m_columns[$p_index]);
    }

    public function get_tables()
    {
        return $this->m_tables;
    }

    public function get_columns()
    {
        return $this->m_columns;
    }

    public function get_headers()
    {
        return $this->m_headers;
    }

    public function get_links()
    {
        return $this->m_links;
    }

    public function set_link($p_col_index, $p_link)
    {
        $this->m_links[$p_col_index] = $p_link;
    }

    public function sort()
    {
        return true;
    }

    /**
     * Filter the workflow list.
     *
     * @param $p_filter_type
     * @param $p_filter
     *
     * @return bool
     */
    public function filter($p_filter_type, $p_filter)
    {
        if ($p_filter_type === 'today') {
            $l_columns = $this->get_columns();
            foreach ($l_columns as $l_key => $l_value) {
                if ($l_value["isys_workflow_action_parameter__datetime"] != $p_filter) {
                    $this->remove_column($l_key);
                }
            }

            return true;
        }

        return false;
    }

    public function assign()
    {
        $orderDirectory = 'DESC';
        $orderField = '';

        if (empty($_POST['order_dir'])) {
            $orderDirectory = 'DESC';
        } elseif ($_POST['order_dir'] == 'DESC') {
            $orderDirectory = 'ASC';
        }

        if (!empty($_POST['order_field'])) {
            $orderField = $_POST['order_field'];
        }

        return isys_application::instance()->container->get('template')
            ->assign("g_post", $_POST)
            ->assign("order_dir", $orderDirectory)
            ->assign("order_field", $orderField)
            ->assign("g_num_rows", count($this->m_columns))
            ->registerObject("isys_workflow_list", $this);
    }

    public function init()
    {
        $this->m_columns = [];
        $this->m_tables = [];
    }
}