<?php

/**
 * i-doit
 *
 * Workflow module class
 *
 * @package     Modules
 * @subpackage  Workflow
 * @version     1.0.0
 * @author      Viviane Götzen <vgoetzen@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_workflow_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/workflow/';
        $classMap = [
            'isys_api_model_cmdb_workflow'        => 'api/isys_api_model_cmdb_workflow.class.php',
            'isys_api_model_console_workflow'     => 'api/isys_api_model_console_workflow.class.php',
            'isys_auth_workflow'                  => 'auth/isys_auth_workflow.class.php',
            'isys_cmdb_dao_category_g_workflow'   => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_workflow.class.php',
            'isys_cmdb_dao_list_catg_workflow'    => 'cmdb/dao/list/isys_cmdb_dao_list_catg_workflow.class.php',
            'isys_cmdb_ui_category_g_workflow'    => 'cmdb/ui/global/isys_cmdb_ui_category_g_workflow.class.php',
            'isys_event'                          => 'event/isys_event.class.php',
            'isys_event_task'                     => 'event/task/isys_event_task.class.php',
            'isys_event_task_accept'              => 'event/task/isys_event_task_accept.class.php',
            'isys_event_task_closed'              => 'event/task/isys_event_task_closed.class.php',
            'isys_event_task_completion_accepted' => 'event/task/isys_event_task_completion_accepted.class.php',
            'isys_event_task_information'         => 'event/task/isys_event_task_information.class.php',
            'isys_event_task_new'                 => 'event/task/isys_event_task_new.class.php',
            'isys_event_task_notification'        => 'event/task/isys_event_task_notification.class.php',
            'isys_event_task_open'                => 'event/task/isys_event_task_open.class.php',
            'isys_handler_workflow'               => 'handler/controller/isys_handler_workflow.class.php',
            'isys_popup_workflow'                 => 'popup/isys_popup_workflow.class.php',
            'isys_workflow'                       => 'isys_workflow.class.php',
            'isys_workflow_action'                => 'action/isys_workflow_action.class.php',
            'isys_workflow_action_accept'         => 'action/isys_workflow_action_accept.class.php',
            'isys_workflow_action_assign'         => 'action/isys_workflow_action_assign.class.php',
            'isys_workflow_action_cancel'         => 'action/isys_workflow_action_cancel.class.php',
            'isys_workflow_action_complete'       => 'action/isys_workflow_action_complete.class.php',
            'isys_workflow_action_new'            => 'action/isys_workflow_action_new.class.php',
            'isys_workflow_action_notification'   => 'action/isys_workflow_action_notification.class.php',
            'isys_workflow_action_parameter'      => 'action/isys_workflow_action_parameter.class.php',
            'isys_workflow_dao'                   => 'dao/isys_workflow_dao.class.php',
            'isys_workflow_dao_action'            => 'dao/isys_workflow_dao_action.class.php',
            'isys_workflow_dao_dynamic'           => 'dao/isys_workflow_dao_dynamic.class.php',
            'isys_workflow_dao_list'              => 'dao/list/isys_workflow_dao_list.class.php',
            'isys_workflow_dao_list_filter'       => 'dao/list/isys_workflow_dao_list_filter.class.php',
            'isys_workflow_dao_list_generic'      => 'dao/list/isys_workflow_dao_list_generic.class.php',
            'isys_workflow_dao_list_template'     => 'dao/list/isys_workflow_dao_list_template.class.php',
            'isys_workflow_dao_list_wf_type'      => 'dao/list/isys_workflow_dao_list_wf_type.class.php',
            'isys_workflow_dao_template'          => 'dao/isys_workflow_dao_template.class.php',
            'isys_workflow_dao_type'              => 'dao/isys_workflow_dao_type.class.php',
            'isys_workflow_data'                  => 'isys_workflow_data.class.php',
            'isys_workflow_event_manager'         => 'event/isys_workflow_event_manager.class.php',
            'isys_workflow_list'                  => 'isys_workflow_list.class.php',
            'isys_workflow_request'               => 'isys_workflow_request.class.php',
            'isys_workflow_status_map'            => 'isys_workflow_status_map.class.php',
            'isys_workflow_view'                  => 'view/isys_workflow_view.class.php',
            'isys_workflow_view_detail'           => 'view/isys_workflow_view_detail.class.php',
            'isys_workflow_view_detail_email_gui' => 'view/isys_workflow_view_detail_email_gui.class.php',
            'isys_workflow_view_detail_generic'   => 'view/isys_workflow_view_detail_generic.class.php',
            'isys_workflow_view_detail_selector'  => 'view/isys_workflow_view_detail_selector.class.php',
            'isys_workflow_view_detail_template'  => 'view/isys_workflow_view_detail_template.class.php',
            'isys_workflow_view_detail_wf_type'   => 'view/isys_workflow_view_detail_wf_type.class.php',
            'isys_workflow_view_list'             => 'view/isys_workflow_view_list.class.php',
            'isys_workflow_view_list_filter'      => 'view/isys_workflow_view_list_filter.class.php',
            'isys_workflow_view_list_handler'     => 'view/isys_workflow_view_list_handler.class.php',
            'isys_workflow_view_list_template'    => 'view/isys_workflow_view_list_template.class.php',
            'isys_workflow_view_list_wf_type'     => 'view/isys_workflow_view_list_wf_type.class.php',
            'isys_workflow_view_tree'             => 'view/isys_workflow_view_tree.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
