<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     i-doit
 * @subpackage  auth
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.2.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.2.0
 */
class isys_auth_workflow extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var isys_auth_check_mk
     */
    private static $m_instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return array
     */
    public function get_auth_methods()
    {
        return [
            'workflow' => [
                'title' => 'LC__AUTH_GUI__WORKFLOWS_CONDITION',
                'type'  => 'workflow'
            ]
        ];
    }

    /**
     * Method for retrieving the "parameter" in the configuration GUI. Gets called generically by "ajax()" method.
     *
     * @param string $p_method
     * @param string $p_param
     * @param int    $p_counter
     * @param bool   $p_editmode
     * @param bool   $p_combo_param This parameter is used, when more than one box is displayed at once (category in object, ...).
     *
     * @return array
     * @see    isys_module_auth->ajax_retrieve_parameter();
     */
    public function retrieve_parameter($p_method, $p_param, $p_counter, $p_editmode = false, $p_combo_param = false)
    {
        $l_return = [
            'html'    => '',
            'method'  => $p_method,
            'param'   => $p_param,
            'counter' => $p_counter
        ];

        $l_dialog_data = null;

        if ($p_method === 'workflow') {
            $l_dialog_data = [
                C__WF__VIEW__DETAIL__EMAIL_GUI => 'LC_WORKFLOW_TREE__EMAIL',
                C__WF__VIEW__LIST_FILTER       => 'LC__WORKFLOWS__MY',
                C__WF__VIEW__LIST_TEMPLATE     => 'LC__WORKFLOW__TEMPLATES',
                C__WF__VIEW__LIST              => 'LC__CMDB__CATG__WORKFLOW'
            ];

            $l_dialog = new isys_smarty_plugin_f_dialog();

            if (is_string($p_param)) {
                $p_param = strtolower($p_param);
            }

            $l_params = [
                'name'              => 'auth_param_form_' . $p_counter,
                'p_arData'          => $l_dialog_data,
                'p_editMode'        => $p_editmode,
                'p_bDbFieldNN'      => 1,
                'p_bInfoIconSpacer' => 0,
                'p_strClass'        => 'input-small',
                'p_strSelectedID'   => $p_param
            ];

            $l_return['html'] = $l_dialog->navigation_edit(isys_application::instance()->container->get('template'), $l_params);

            return $l_return;
        }

        return $l_return;
    }

    /**
     * Determines the rights for the workflows.
     *
     * @param integer $p_right
     * @param mixed   $p_type
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Van Quyen Hoang <qhoang@i-doit.com>
     */
    public function workflow($p_right, $p_type)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->check_module_rights($p_right, 'workflow', $p_type, new isys_exception_auth(isys_application::instance()->container->get('language')
            ->get('LC__AUTH__SYSTEM_EXCEPTION__MISSING_RIGHT_FOR_WORKFLOWS')));
    }

    /**
     * Get ID of related module
     *
     * @return int
     */
    public function get_module_id()
    {
        return C__MODULE__WORKFLOW;
    }

    /**
     * Get title of related module
     *
     * @return string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__WORKFLOW';
    }

    /**
     * Retrieve singleton instance of authorization class
     *
     * @return self
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }
}
