<?php

/**
 * i-doit
 *
 *
 * @package     i-doit
 * @subpackage  Workflow
 * @author      Dennis Stücken <dstuecken@i-doit.org>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_workflow_request extends isys_workflow
{
    /**
     * @var int
     */
    private $m_from;

    /**
     * @var  array
     */
    private $m_meta;

    /**
     * @var  array
     */
    private $m_request;

    /**
     * @var  string
     */
    private $m_to;

    /**
     * @var  integer
     */
    private $m_workflow_type;

    /**
     * Returns the request.
     *
     * @return  array
     */
    public function get_request()
    {
        return $this->m_request;
    }

    /**
     * Returns the "from" contact ID.
     *
     * @return  integer
     */
    public function get_from()
    {
        return $this->m_from;
    }

    /**
     * Returns the "to" contact ID.
     *
     * @return  integer
     */
    public function get_to()
    {
        return $this->m_to;
    }

    /**
     * Returns the meta information.
     *
     * @return  array
     */
    public function get_meta()
    {
        return $this->m_meta;
    }

    /**
     * Returns the workflow type.
     *
     * @return  integer
     */
    public function get_workflow_type()
    {
        return $this->m_workflow_type;
    }

    /**
     *
     * @return  boolean
     */
    public function format_request()
    {
        $l_request = $this->m_request;
        $this->m_meta = $l_request;
        $l_new_request = [];

        if (!empty($this->m_workflow_type)) {
            $l_dao_wf_tpl = new isys_workflow_dao_template(isys_application::instance()->container->get('database'));
            $l_template_parameter = $l_dao_wf_tpl->get_template_parameter($this->m_workflow_type);

            foreach ($l_template_parameter as $l_value) {
                $l_param = $l_value["key"];

                // 4 = DATETIME
                if ($l_value["type"] <> 4) {
                    $l_new_request[$l_param] = $l_request[$l_param];
                } else {
                    $l_new_request[$l_param] = $l_request[$l_param . "__HIDDEN"];
                }
            }
        } else {
            return false;
        }

        $this->m_request = $l_new_request;

        return true;
    }

    /**
     * @param   integer $p_user_id
     *
     * @return  integer
     */
    public function set_initiator($p_user_id)
    {
        $l_dao_reference = new isys_contact_dao_reference(isys_application::instance()->container->get('database'));
        $l_dao_reference->insert_data_item($p_user_id, C__CONTACT__DATA_ITEM__PERSON_INTERN);
        $l_contact_id = null;

        if ($l_dao_reference->save()) {
            $l_contact_id = $l_dao_reference->get_id();
        }

        $this->m_from = $l_contact_id;

        return $l_contact_id;
    }

    /**
     * Workflow-type setter.
     *
     * @param  integer $p_workflow_type
     */
    public function set_workflow_type($p_workflow_type)
    {
        $this->m_workflow_type = $p_workflow_type;
    }

    /**
     * Constructor.
     *
     * @param  array   $p_request
     * @param  integer $p_from
     * @param  integer $p_to
     */
    public function __construct($p_request, $p_from, $p_to)
    {
        $this->m_request = $p_request;
        $this->m_to = $p_to;

        $this->set_initiator($p_from);
    }
}