<?php

/**
 * i-doit
 *
 *
 * @package    i-doit
 * @subpackage Workflow
 * @author     Dennis Stücken <dstuecken@i-doit.org>
 * @version    1.0
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_workflow_status_map extends isys_workflow
{

    /**
     * @desc status description as language constants
     * @var array
     */
    private $m_description = [];

    /**
     * @desc status ids
     * @var array
     */
    private $m_status;

    public function build_map()
    {
        $l_workflow_dao = new isys_workflow_dao_action(isys_application::instance()->container->get('database'));
        $l_status = $l_workflow_dao->get_status();
        while ($l_row = $l_status->get_row()) {
            $l_id = $l_row["isys_workflow_status__id"];
            $l_title = isys_application::instance()->container->get('language')
                ->get($l_row["isys_workflow_status__title"]);

            $this->set($l_id, $l_title);
        }

        return true;
    }

    public function get($p_id)
    {
        if (array_key_exists($p_id, $this->m_description)) {
            return $this->m_description[$p_id];
        } else {
            return false;
        }
    }

    public function set($p_id, $p_description)
    {
        if (!array_key_exists($p_id, $this->m_description)) {
            $this->m_description[$p_id] = $p_description;
        } else {
            return false;
        }
    }

}
