<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @version    1.0 Wed Jun 21 11:49:57 CEST 2006 11:49:57
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_workflow_dao_list_template extends isys_workflow_dao_list
{
    /**
     * Method for retrieving the field names.
     *
     * @return  array
     */
    public function get_fields()
    {
        return [
            "isys_workflow_template_parameter__id"    => "ID",
            "isys_workflow_type__title"               => "LC_WORKFLOW__TYPE",
            "isys_workflow_template_parameter__title" => "LC__TASK__TITLE",
            "isys_workflow_template_parameter__key"   => "Key",
        ];
    }

    /**
     * @desc get sql
     *
     */
    public function get_sql($p_workflow_type__id = null)
    {
        $l_sql = "SELECT * FROM isys_workflow_template_parameter " . "LEFT OUTER JOIN isys_wf_type_2_wf_tp " . "ON " .
            "isys_wf_type_2_wf_tp__isys_workflow_template_parameter__id = " . "isys_workflow_template_parameter__id " . "LEFT OUTER JOIN isys_workflow_type " . "ON " .
            "isys_wf_type_2_wf_tp__isys_workflow_type__id = " . "isys_workflow_type__id " . "WHERE TRUE ";

        if (!is_null($p_workflow_type__id)) {
            $l_sql .= " AND (isys_workflow_type__id = '" . $p_workflow_type__id . "') ";
        }

        return $l_sql;
    }

    public function get_row_link($p_get_params = null)
    {
        $l_gets = isys_module_request::get_instance()
            ->get_gets();

        $l_link[C__GET__MAIN_MENU__NAVIGATION_ID] = $l_gets[C__GET__MAIN_MENU__NAVIGATION_ID];

        $l_link[C__GET__MODULE_ID] = C__MODULE__WORKFLOW;
        $l_link[C__CMDB__GET__TREEMODE] = C__WF__VIEW__TREE;
        $l_link[C__CMDB__GET__VIEWMODE] = C__WF__VIEW__DETAIL__TEMPLATE;
        $l_link[C__WF__GET__TYPE] = $l_gets[C__WF__GET__TYPE];
        $l_link[C__WF__GET__TEMPLATE] = "[{isys_workflow_template_parameter__id}]";

        return "?" . urldecode(isys_glob_http_build_query($l_link));
    }

    public function __construct(isys_component_database &$p_db)
    {
        parent::__construct($p_db);

        $onclickJsText = "var checkedRows = $$('tr.tr-selected'); if(checkedRows.length === 0){return;}; 
        var action = checkedRows[0].getAttribute('data-link'); document.isys_form.action = action; 
        document.isys_form.sort.value=''; document.isys_form.navMode.value='" . C__NAVMODE__EDIT . "'; form_submit(); ";
        isys_component_template_navbar::getInstance()->set_js_onclick($onclickJsText, C__NAVMODE__EDIT);
    }
}

?>
